//=============================================================================
// SoR_UnlimitEnemyStatus_MZ.js
// SoR License (C) 2020 蒼竜, REQUIRED User Registration on Dragon Cave
// http://dragonflare.blue/dcave/license.php
// ---------------------------------------------------------------------------
// Latest version v1.30 (2022/09/17)
//=============================================================================
/*:ja
@plugindesc ＜エネミーステータス上限拡張＞ v1.30
@author 蒼竜
@target MZ
@orderAfter SoR_TagDataProcessor_MZ
@base SoR_TagDataProcessor_MZ
@url https://dragonflare.blue/dcave/
@help エネミーのデータベース内設定項目に対して、対象エネミーのメモ欄に
タグを記述することにより、エディタ上限を無視した設定を可能にします。

---タグ形式1---
<[X]: [Y]>

[X]: 設定項目(mhp,mmp,atk,def,mat,mdf,agi,luk,exp,gold) 大文字・小文字不問
[Y]: 値(整数値)

---タグ形式2---
<ExDrop: [X], [Y], [Z](, [W])>

[X]: アイテム種別
[Y]: アイテムID
[Z]: ドロップ確率 (0以上1以下の実数)
[W]: ドロップ基本条件(任意)
*/
/*:
@plugindesc <Unlimited Enemy Status and Extension> v1.30
@author Soryu
@target MZ
@url https://dragonflare.blue/dcave/index_e.php
@orderAfter SoR_TagDataProcessor_MZ
@base SoR_TagDataProcessor_MZ
@help For configurable items for enemies in the database, this plugin 
overcomes the upper limit constrained by RPGMaker with tags notation in the note.

---Tag Format 1---
<[X]: [Y]>

[X]: Target Items(mhp,mmp,atk,def,mat,mdf,agi,luk,exp,gold)
[Y]: Value (Integer)

---Tag Format 2---
<ExDrop: [X], [Y], [Z](, [W])>

[X]: Item Type
[Y]: Item ID
[Z]: Probability (Real number between 0 and 1)
[W]: Drop Condition Text (optional)
*/
var SoR = SoR || {};
(function() {
if(!PluginManager._scripts.includes("SoR_TagDataProcessor_MZ")) throw new Error("[SoR_UnlimitEnemyStatus_MZ] This plugin REQUIRES SoR_TagDataProcessor_MZ.");
const Param = PluginManager.parameters('SoR_UnlimitEnemyStatus_MZ');

const SoR_UES_DM_initializeSoRTagProcessor = DataManager.initializeSoRTagProcessor;
DataManager.initializeSoRTagProcessor = function() {
    SoR_UES_DM_initializeSoRTagProcessor.call(this);
    const q = {name: "SoRTagUES", target: ["enemy"]};
    this._SoRTagProcessFuncs.push(q);
}

const tags = [];
tags.push(/<(?:mhp):?[ ]*(\d+)?>/i);
tags.push(/<(?:mmp):?[ ]*(\d+)?>/i);
tags.push(/<(?:atk):?[ ]*(\d+)?>/i);
tags.push(/<(?:def):?[ ]*(\d+)?>/i);
tags.push(/<(?:mat):?[ ]*(\d+)?>/i);
tags.push(/<(?:mdf):?[ ]*(\d+)?>/i);
tags.push(/<(?:agi):?[ ]*(\d+)?>/i);
tags.push(/<(?:luk):?[ ]*(\d+)?>/i);
const n_tags = tags.length;

DataManager.SoRTagUES_init = function(obj) {}
DataManager.SoRTagUES = function(obj, line) {
    let MatchFlag = true;

    for(let t = 0; t < n_tags; t++){
        if(line.match(tags[t])){
            obj.params[t] = parseInt(RegExp.$1);
            return MatchFlag;
        }
    }
    if(line.match(/<(?:exp):?[ ]*(\d+)?>/i)) obj.exp = parseInt(RegExp.$1);
    else if(line.match(/<(?:gold):?[ ]*(\d+)?>/i)) obj.gold = parseInt(RegExp.$1);
    else if(line.match(/<(?:exdrop):?[ ]*(\d+),?[ ]*(\d+),?[ ]*([1|0]\.\d+)?[ ]*(.*)>/i)){
        const newdrop = {kind: -1, exkind: parseInt(RegExp.$1), dataId: parseInt(RegExp.$2), probability: Number(RegExp.$3), denominator: 0, cond: "true"};

        const tag3 = /,[ ]*(.*)/i;
        let cond = "";
        const condtext = RegExp.$4;
        if(condtext.match(tag3)) newdrop.cond = String(RegExp.$1).trim();

        const index = obj.dropItems.findIndex(item => item.kind === 0);
        if(index!==-1) obj.dropItems[index] = newdrop;
        else obj.dropItems.push(newdrop);
    }
    else if(line.match(/<(?:exdrop2):?[ ]*(\d+),?[ ]*(\d+),?[ ]*(\d+),?[ ]*([1|0]\.\d+)?[ ]*(.*)>/i)){//enhanced items
        const newdrop = {kind: -1, exkind: parseInt(RegExp.$1), dataId: parseInt(RegExp.$2),
						probability: Number(RegExp.$4), denominator: 0, cond: "true", exdataSourceId: parseInt(RegExp.$3)};
        const tag3 = /,[ ]*(.*)/i;
        let cond = "";
        const condtext = RegExp.$5;
        if(condtext.match(tag3)) newdrop.cond = String(RegExp.$1).trim();

        const index = obj.dropItems.findIndex(item => item.kind === 0);
        if(index!==-1) obj.dropItems[index] = newdrop;
        else obj.dropItems.push(newdrop);
    }
    else MatchFlag = false;

    return MatchFlag;
}


/////////////////////////////////////////////////////////////////////////////////
const SoR_UES_GE_makeDropItems = Game_Enemy.prototype.makeDropItems;
Game_Enemy.prototype.makeDropItems = function() {
    let droptable = SoR_UES_GE_makeDropItems.call(this);

    const rate = this.dropItemRate();
    const exdroptb = this.enemy().dropItems.reduce((r, di) => {
            //original drop table
            if(di.probability && di.exkind > 0 && Math.random() >= 1-di.probability*rate) {
               if(SoR_Eval(di.cond)==true){
				   const baseobj = this.itemObject(di.exkind, di.dataId);
				   const ret = this.processDropEX(baseobj,di);
				   return r.concat(ret);
			   }
            }

            return r;
    }, []); 
    
    droptable = droptable.concat(exdroptb);
    return droptable;
}

Game_Enemy.prototype.processDropEX = function(itemobj, di) {
    return itemobj;
}


/////////////////////////////////////////////////////////////////////////////////////
function SoR_Eval(ev) {
    const sentence = "return (" + ev + ");";

    if(typeof $gameTemp.SoRTmp_script === "undefined") $gameTemp.SoRTmp_script = new Map();
    if(!$gameTemp.SoRTmp_script.has(sentence)){
        $gameTemp.SoRTmp_script.set(sentence, new Function(sentence));
    }
    const res = $gameTemp.SoRTmp_script.get(sentence)();
    return res;
}

})();