//=============================================================================
// SoR_PartyEquipmentStorageRefactor_MZ.js
// SoR License (C) 2020 蒼竜, REQUIRED User Registration on Dragon Cave
// http://dragonflare.blue/dcave/license.php
// ----------------------------------------------------------------------------
// Latest version v1.00 (2022/09/14)
//=============================================================================
/*:ja
@plugindesc ＜装備品システム拡張基礎＞ v1.00
@author 蒼竜
@target MZ
@url https://dragonflare.blue/dcave/
@help 装備品、およびそのRPGツクール上の基本メカニズムに対して、
強化・精錬や特殊スロット拡張を実装するための基礎的な仕様変更を行います。

同一の装備品であっても、ゲーム上で各々が固有のIDを持ち、
独立したアイテムとして管理されることで、付加される特殊効果が異なったり、
プレイヤー独自のカスタマイズが適用された同名の装備品を実装することができます。

※関連するプラグインにとって必須の基礎プラグインとなります。
機能の性質上、大きな競合リスクを伴います。他者作の抜本的なアイテムシステム
変更を伴うプラグインとは基本的に両立しませんので、ご注意ください。
*/
/*:
@plugindesc <Party Equipment Storage Refactor> v1.00
@author Soryu
@target MZ
@url https://dragonflare.blue/dcave/index_e.php
@help This plugin refactorizes the fundamental mechanism of the 
corescript on RMMZ regarding on items(equipment), which 
aims to implementation of item enforcement and extentional 
customization.

Items which have the same ID on the database are distinguished
by unique IDs for independent treatment during the game. Thus,
we can implement the same equipment with different additional
effects and player customization.

[NOTE]
This plugin becomes a fundamental for related plugins. Due to 
its internal implementation, the conflict risk is relatively
larger than other our plugins. It is hardly compatible with most 
plugins intending drastic system changes developed by others.
*/

(function() {
const pluginName = "SoR_PartyEquipmentStorageRefactor_MZ";
const Param = PluginManager.parameters(pluginName);

const SoR_PESR_GP_initAllItems = Game_Party.prototype.initAllItems;
Game_Party.prototype.initAllItems = function() {
    SoR_PESR_GP_initAllItems.call(this);
    this.initAllExOriginalItems();
}

Game_Party.prototype.initAllExOriginalItems = function() {
    // { id: (originItemId)
    //   addData: [{type: (effectItemtype), id: (effectItemID)}]
    //   addEffects: [{???: ???  (original effects}]
    //   newname: (extended Item name ???)
    // }
    this._exItems = [];
    this._exWeapons = [];
    this._exArmors = [];
}



/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
// overwritten  (to be examined well)
/////////////////////////////////////////////////////////////////////
Game_Actor.prototype.changeEquip = function(slotId, item) {
    if (
        this.tradeItemWithParty(item, this.equips()[slotId]) &&
        (!item || this.equipSlots()[slotId] === item.etypeId)
    ) { 
		const newItem = item;
		const oldItem = this.equips()[slotId];
        this._equips[slotId].setObject(item);
		$gameParty.loseItem(newItem, 1); ///
		$gameParty.gainItem(oldItem, 1); ///
        this.refresh();
    }
}

Game_Actor.prototype.tradeItemWithParty = function(newItem, oldItem) {
    if (newItem && !$gameParty.hasItem(newItem)) return false;
    else return true;
}
/////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////////////
Game_Party.prototype.items = function() {
    return Object.keys(this._items).map(id => {
        if(id < $dataItems.length) return $dataItems[id];
        else return this.extendedData(id);
    });
}

Game_Party.prototype.weapons = function() {
    return Object.keys(this._weapons).map(id => {
        if(id < $dataWeapons.length) return $dataWeapons[id];
        else return this.extendedData(id);
    });
}

Game_Party.prototype.armors = function() {
    return Object.keys(this._armors).map(id => {
        if(id < $dataArmors.length) return $dataArmors[id];
        else return this.extendedData(id);
    });
}


/////////////////////////////////////////////////////////////////////
const SoR_PESR_GI_setObject = Game_Item.prototype.setObject;
Game_Item.prototype.setObject = function(item) {
    SoR_PESR_GI_setObject.call(this, ...arguments);
    if(item){
        if(item.hasOwnProperty("exdataId")) this.exdataId = item.exdataId;
        else if(this.hasOwnProperty("exdataId")) delete this.exdataId;
    }
}

const SoR_PESR_GI_object = Game_Item.prototype.object;
Game_Item.prototype.object = function() {
    if(this.hasOwnProperty("exdataId")){
        if (this.isItem()) return $gameParty.extendedData(100000+this.exdataId);
        else if (this.isWeapon()) return $gameParty.extendedData(200000+this.exdataId);
        else if (this.isArmor()) return $gameParty.extendedData(300000+this.exdataId);
        else return null;
    }

    return SoR_PESR_GI_object.call(this);
}

///////////////////////////////////////////////////////////////
Game_Party.prototype.extendedData = function(id) {
    let exData, sourceData;
    //{ id: (originItemId)
    //  addData: [{type: (effectItemtype), id: (effectItemID)}]   <--- 別のアイテムのIDを与えて、情報をコピー・反映する
    //  addEffects: [{???: ???  (original effects}] <--- その他追加効果
    //  newname: (extended Item name ???) <--- 接頭辞
    //}
    const ret = DataManager.getIndividualContainer_ExOriginalItems(id);

    if(ret.type==0){
        exData = this._exItems[ret.id];
        sourceData = $dataItems[exData.id];
    }
    else if(ret.type==1){
        exData = this._exWeapons[ret.id];
        sourceData = $dataWeapons[exData.id];
    }
    else if(ret.type==2){
        exData = this._exArmors[ret.id];
        sourceData = $dataArmors[exData.id];
    }
    else return undefined;

    return DataManager.generateItemWithEXproperty(sourceData, exData, ret.id);
}
/////////////////////////////////////////////////////////////////////
//
// exOriginal itemの入手法
// gainする直前でexdataをcreateして"exdataId"で紐づけしたデータを渡す
//
/////////////////////////////////////////////////////////////////////

const SoR_PESR_GP_gainItem = Game_Party.prototype.gainItem;
Game_Party.prototype.gainItem = function(item, amount, includeEquip) {
    if(item==null) return;

    if(item.hasOwnProperty("exdataId")) this.gainExOriginalItem(...arguments);
    else SoR_PESR_GP_gainItem.call(this,...arguments);
}

/*
DataManager.createNewExItem = function(){}
*/

DataManager.registerNewExItem = function(origItem, property){
    const exContainer = this.getExOriginalItemContainer(origItem);//weapon
	
	////////////////////////////////////////////////////////////////////////
	// Considering with individual customization for exItems,
	// we also treat custom properties with the same ID as
	// different from each other in the exItem arrays.
	////////////////////////////////////////////////////////////////////////
	
	//削除後empty check
	idx = exContainer.findIndex(x=>!x);
	if(idx!=-1){
		exContainer.splice(idx,1,property);
	}
	else{//create new custom property
		exContainer.push(property);
		idx = exContainer.length-1;
	}
	
    const exdata = this.generateItemWithEXproperty(origItem,property, idx);
    $gameParty.gainItem(exdata,1,false);
}

DataManager.generateItemWithEXproperty = function(orig, exDataItem, exdataID){
    const exdata = JSON.parse(JSON.stringify(orig));

    const data = exDataItem;
    const exeff = [];
    for(const eff of data.addData){ //additional item effects
        if(eff.type == "item") exeff.push($dataItems[eff.id]);
        else if(eff.type == "weapon") exeff.push($dataWeapons[eff.id]);
        else if(eff.type == "armor") exeff.push($dataArmors[eff.id]);
    }
    const exeff2 = [];
    for(const eff of data.addEffects){ //additional original effects
        /// ...
    }


    for(const exi of exeff){
        if(exdata.params && exi.params){
            const np = exdata.params.length;
            for(let i = 0; i < np; i++) exdata.params[i] += exi.params[i];
        }
        exdata.price += exi.price;
        exdata.traits = exdata.traits.concat(exi.traits);
        if(exi.passiveEffects){
            if(!exdata.passiveEffects) exdata.passiveEffects = exi.passiveEffects;
            else exdata.passiveEffects = exdata.passiveEffects.concat(exi.passiveEffects);
        }
    }
 
    exdata.name = data.newname.format(exdata.name);
    exdata.exdataId = exdataID;
    return exdata;
}


const SoR_PESR_GP_numItems = Game_Party.prototype.numItems;
Game_Party.prototype.numItems = function(item) {
    if(item.hasOwnProperty("exdataId")) return this.numExOriginalItem(...arguments);
    else return SoR_PESR_GP_numItems.call(this,...arguments);
}
Game_Party.prototype.numExOriginalItem = function(item) {
    const container = this.itemContainer(item);
    const idx = DataManager.getContainerID_ExOriginalItems(item);
    return container[idx];
}


Game_Party.prototype.gainExOriginalItem = function(item, amount, includeEquip) {
    const container = this.itemContainer(item);

    if (container) {
        const exID = DataManager.getContainerID_ExOriginalItems(item);

        if(amount>0){
            container[exID] = 1;
        }
        else{
			const ex_arrId = item.exdataId;
			//const typeid = DataManager.getExOriginalItemContainerID(item);
			const exContainer = DataManager.getExOriginalItemContainer(item);
			//const headIdx = DataManager.getContainerID_ExOriginal_HeadID(item);
			if(this.hasExtendedItem(ex_arrId) == false){
				delete exContainer[ex_arrId];
			}
			delete container[exID]; //delete original item
        }
        /*
        if (includeEquip && newNumber < 0) {
            this.discardMembersEquip(item, -newNumber);
        }*/
        $gameMap.requestRefresh();
    }
}


DataManager.getContainerID_ExOriginalItems = function(item) {
    const val = DataManager.getContainerID_ExOriginal_HeadID(item);	
    return val + item.exdataId;
}

DataManager.getContainerID_ExOriginal_HeadID = function(item) {
    const typeid = DataManager.getExOriginalItemContainerID(item);
    ///// exitemIDs
    //exItem +100000
    //exWeapon +200000
    //exArmor +300000
    return 100000*(typeid+1);
}

DataManager.getIndividualContainer_ExOriginalItems = function(id) {
    return {type: Math.floor(id/100000)-1, id: Math.floor(id%100000)};
}


/////////////////////////////////////////////////////////////////////
Game_Party.prototype.hasExtendedItem = function(target) {
	if(PluginManager._scripts.includes("SoR_ItemsWarehouse_MZ") || PluginManager._scripts.includes("SoR_ItemsWarehouse_MZ_X")){
		if($gameParty.numWarehouseItems(target)>0) return true;
	}
	
	for(const x of this.allMembers()){
		if(!x) continue;
		const ret = x.hasExtendedItem(target);
		if(ret==true) return true;
	}
	
	return false;
}

Game_Actor.prototype.hasExtendedItem = function(target) {
	const equips = this.equips();
	const neq = equips.length;
	for (let i = 0; i < neq; i++) {
		if(!equips[i]) continue;
		if(equips[i].hasOwnProperty("exdataId")){/////////////////
			if(target==null) return true;
			if(target==equips[i].exdataId) return true;
		}
	}
	
	return false;
}



/////////////////////////////////////////////////////////////////////
const SoR_PESR_DM_isItem = DataManager.isItem;
DataManager.isItem = function(item) {
    const base = SoR_PESR_DM_isItem.call(this, ...arguments);
    if(base==true) return true;

    const add = this.isValidOriginalItem(item,0);
    return add;
}

const SoR_PESR_DM_isWeapon = DataManager.isWeapon;
DataManager.isWeapon = function(item) {
    const base = SoR_PESR_DM_isWeapon.call(this, ...arguments);
    if(base==true) return true;

    const add = this.isValidOriginalItem(item,1);
    return add;
}

const SoR_PESR_DM_isArmor = DataManager.isArmor;
DataManager.isArmor = function(item) {
    const base = SoR_PESR_DM_isArmor.call(this, ...arguments);
    if(base==true) return true;

    const add = this.isValidOriginalItem(item,2);
    return add;
}

DataManager.isValidOriginalItem = function(item, type) {
    if(!item) return false;
    
    if(type==0){
        if(!item.itypeId) return false;
    }
    else if(type==1){
        if(!item.wtypeId) return false;
    }
    else if(type==2){
        if(!item.atypeId) return false;
    }

    if(!item.hasOwnProperty("exdataId")) return false; //ID may become 0.
    
    return true;
}

DataManager.getExOriginalItemContainerID = function(item) {
    if(item.itypeId) return 0;
    if(item.wtypeId) return 1;
    if(item.atypeId) return 2;
    return null;
}
DataManager.getExOriginalItemContainer = function(item) {
    if(item.itypeId) return $gameParty._exItems;
    if(item.wtypeId) return $gameParty._exWeapons;
    if(item.atypeId) return $gameParty._exArmors;
    return null;
}
/////////////////////////////////////////////////////////////////////



})();