//=============================================================================
// SoR_EffectEnhancedItems_MZ.js
// SoR License (C) 2020 蒼竜, REQUIRED User Registration on Dragon Cave
// http://dragonflare.blue/dcave/license.php
// ----------------------------------------------------------------------------
// Latest version v1.01 (2022/12/14)
//=============================================================================
/*:ja
@plugindesc ＜拡張効果付帯アイテム＞ v1.01
@author 蒼竜
@target MZ
@url https://dragonflare.blue/dcave/
@orderAfter SoR_PartyEquipmentStorageRefactor_MZ
@orderAfter SoR_TagDataProcessor_MZ
@base SoR_PartyEquipmentStorageRefactor_MZ
@base SoR_TagDataProcessor_MZ
@help ※要 88.「SoRタグデータ解析」(SoR_TagDataProcessor_MZ.js)
※要 148.「装備品システム拡張基礎」(SoR_PartyEquipmentStorageRefactor_MZ.js)
[注意1] 外部データベース定義を使用する場合
※要 71.「外部メモ欄拡張」(SoR_DataNoteExtension_MZ.js)
[注意2] さらに、エネミードロップに効果付与状態のアイテムを含める場合
※要 33.「エネミーステータス上限拡張」　v1.30以上 (SoR_UnlimitEnemyStatus_MZ.js)

アイテムや装備品に対して、
追加効果が付与された「同名の特殊アイテム」を実装します。

システム上の実効果は、「データベース上で定義された元のアイテムに
指定の別のアイテム・装備品の効果を上乗せする」ものです。

※ 本プラグイン(および基礎プラグイン)単体の機能は完結していますが、
他SoRプラグインとの整合性は現在のところ不完全です。

@command createEnhancedItem
@text アイテム生成 [拡張効果付帯アイテム]
@desc 指定効果を付与されたアイテムを生成し、プレイヤーに与えます。

@arg arg0
@text 元にするアイテムのタイプ
@type select
@desc 拡張効果を付帯させる元のアイテムのタイプ
@option アイテム
@value 1
@option 武器
@value 2
@option 防具
@value 3
@default 1

@arg arg1
@text 《どれか1つ》元にするアイテム
@type item
@default 0
@desc 拡張する元のタイプが「アイテム」の場合の対象
@arg arg2
@text 《どれか1つ》元にする武器
@type weapon
@default 0
@desc 拡張する元のタイプが「武器」の場合の対象
@arg arg3
@text 《どれか1つ》元にする防具
@type armor
@default 0
@desc 拡張する元のタイプが「防具」の場合の対象

@arg arg4
@text 付帯効果に対応するアイテム
@type item[]
@default []
@desc 拡張効果として付帯させる「アイテム」
@arg arg5
@text 付帯効果に対応する武器
@type weapon[]
@default []
@desc 拡張効果として付帯させる「武器」
@arg arg6
@text 付帯効果に対応する防具
@type armor[]
@default []
@desc 拡張効果として付帯させる「防具」

@arg arg7
@text 新しいアイテム名
@desc 効果付帯状態におけるアイテムの名前。「%1」は元にするアイテム名を引用する制御文字
@default %1

@command createEnhancedItem2
@text アイテム生成DB [拡張効果付帯アイテム]
@desc 予め付与効果を定義したデータベース内の要素を指定して、アイテムを生成します。

@arg arg0
@text 元にするアイテムのタイプ
@type select
@desc 拡張効果を付帯させる元のアイテムのタイプ
@option アイテム
@value 1
@option 武器
@value 2
@option 防具
@value 3
@default 1

@arg arg1
@text 《どれか1つ》元にするアイテム
@type item
@default 0
@desc 拡張する元のタイプが「アイテム」の場合の対象
@arg arg2
@text 《どれか1つ》元にする武器
@type weapon
@default 0
@desc 拡張する元のタイプが「武器」の場合の対象
@arg arg3
@text 《どれか1つ》元にする防具
@type armor
@default 0
@desc 拡張する元のタイプが「防具」の場合の対象

@arg arg4
@text 「付与する付帯効果」のID
@desc "SoR_DataNoteExtension"の機能を用いて、先にコモンイベント上にデータベース設定用のタグ記述を行う必要があります。
@type number
@default 1
@min 1

@command callEnhancedItemShop
@text ショップの処理・拡張 [拡張効果付帯アイテム]
@desc 拡張効果を付与したアイテムを陳列できるイベントコマンド「ショップの処理」を実行します。
@arg inventory
@text インベントリ
@desc このショップで販売するアイテムのリスト
@type struct<ExShop>[]
@default []
@arg buyOnly
@desc trueにすると販売専用のショップ処理を実行します。
@type boolean
@default false
*/
/*:
@plugindesc <Enhanced Items with Additional Effects> v1.01
@author Soryu
@target MZ
@url https://dragonflare.blue/dcave/index_e.php
@orderAfter SoR_PartyEquipmentStorageRefactor_MZ
@orderAfter SoR_TagDataProcessor_MZ
@base SoR_PartyEquipmentStorageRefactor_MZ
@base SoR_TagDataProcessor_MZ
@help [Prerequisite] 88. SoR_TagDataProcessor_MZ
[Prerequisite] 148. SoR_PartyEquipmentStorageRefactor_MZ

[Note1] To utilize external database for custom effect management,
Prerequisite 71. SoR_DataNoteExtension_MZ.js
[Note2] To let enemies drop items applied customization,
Prerequisite 33.　SoR_UnlimitEnemyStatus_MZ.js (v1.30 or higher)

This plugin implements alias items with specific customization and 
extension based on the original item on the game. It actually 
add parameters and traits of designated items to the target item 
and implement it on the game as an unique item.

Note that this plugin is still under development about compatibility
with the existing SoR plugins (cooperation with added features).

@command createEnhancedItem
@text Item Generation [Enhanced Items with Additional Effects]
@desc Generate an item added params of designated items to give it to the player.

@arg arg0
@text Type of Base Item
@type select
@desc The source item which is applied customization
@option Item
@value 1
@option Weapon
@value 2
@option Armor
@value 3
@default 1

@arg arg1
@text <Either One> Base Item
@type item
@default 0
@desc Select one if you choose "Item" for "Type of Base Item".
@arg arg2
@text <Either One> Base Weapon
@type weapon
@default 0
@desc Select one if you choose "Weapon" for "Type of Base Item".
@arg arg3
@text <Either One> Base Armor
@type armor
@default 0
@desc Select one if you choose "Armor" for "Type of Base Item".

@arg arg4
@text Added items as customization
@type item[]
@default []
@desc The list of items whose parameters and traits are applied to the base item
@arg arg5
@text Added weapons as customization
@type weapon[]
@default []
@desc The list of weapons whose parameters and traits are applied to the base item
@arg arg6
@text Added armors as customization
@type armor[]
@default []
@desc The list of armors whose parameters and traits are applied to the base item

@arg arg7
@text New Item Name
@desc The item name after customization where %1 is replaced with the name of base item
@default %1

@command createEnhancedItem2
@text Item Generation DB [Enhanced Items with Additional Effects]
@desc Generate an item added params of a designated effect set on the external database to give it to the player.

@arg arg0
@text Type of Base Item
@type select
@desc The source item which is applied customization
@option Item
@value 1
@option Weapon
@value 2
@option Armor
@value 3
@default 1

@arg arg1
@text <Either One> Base Item
@type item
@default 0
@desc Select one if you choose "Item" for "Type of Base Item".
@arg arg2
@text <Either One> Base Weapon
@type weapon
@default 0
@desc Select one if you choose "Weapon" for "Type of Base Item".
@arg arg3
@text <Either One> Base Armor
@type armor
@default 0
@desc Select one if you choose "Armor" for "Type of Base Item".

@arg arg4
@text Effect Set ID
@desc ID of the effect set on the external database by "SoR_DataNoteExtension"
@type number
@default 1
@min 1

@command callEnhancedItemShop
@text Extended Shop [Enhanced Items with Additional Effects]
@desc This an extensive shop command which calls a shop can vend enhanced items by customization.
@arg inventory
@text Inventory
@desc The list of items sold in this shop
@type struct<ExShopE>[]
@default []
@arg buyOnly
@desc If true, players can only buy in this shop.
@type boolean
@default false
*/
/*~struct~ExShop:
@param origin_type
@text 元にするアイテムのタイプ
@type select
@desc 拡張効果を付帯させる元のアイテムのタイプ
@option アイテム
@value 1
@option 武器
@value 2
@option 防具
@value 3
@default 1

@param item_i
@text 《どれか1つ》元にするアイテム
@type item
@default 0
@desc 拡張する元のタイプが「アイテム」の場合の対象
@param item_w
@text 《どれか1つ》元にする武器
@type weapon
@default 0
@desc 拡張する元のタイプが「武器」の場合の対象
@param item_a
@text 《どれか1つ》元にする防具
@type armor
@default 0
@desc 拡張する元のタイプが「防具」の場合の対象

@param addId
@text 付与する付帯効果ID
@desc "SoR_DataNoteExtension"で作成した付与効果データベース上のID、0にすると付与効果なしのアイテムに
@type number
@default 1
@min 0

@param price
@text 値段
@desc このアイテムの販売価格(-1設定でデータベース設定に準拠)
@type number
@default -1
@min -1

@param Note
@type string
@desc 注釈・メモ欄(プラグイン効果には影響なし)
*/
/*~struct~ExShopE:
@param origin_type
@text Type of Base Item
@type select
@desc The source item which is applied customization
@option Item
@value 1
@option Weapon
@value 2
@option Armor
@value 3
@default 1

@param item_i
@text <Either One> Base Item
@type item
@default 0
@desc Select one if you choose "Item" for "Type of Base Item".
@param item_w
@text <Either One> Base Weapon
@type weapon
@default 0
@desc Select one if you choose "Weapon" for "Type of Base Item".
@param item_a
@text <Either One> Base Armor
@type armor
@default 0
@desc Select one if you choose "Armor" for "Type of Base Item".

@param addId
@arg arg4
@text Effect Set ID
@desc ID of the effect set on the external database by "SoR_DataNoteExtension", set 0 to display as a normal item.
@type number
@default 1
@min 0

@param price
@text Price
@desc The price of this item in this shop, set -1 to follow that given in the database.
@type number
@default -1
@min -1

@param Note
@type string
@desc Note area for developers (no effects for games)
*/
(function() {
if(!PluginManager._scripts.includes("SoR_PartyEquipmentStorageRefactor_MZ")) throw new Error("[SoR_EffectEnhancedItems_MZ] This plugin REQUIRES SoR_PartyEquipmentStorageRefactor_MZ.");
if(!PluginManager._scripts.includes("SoR_TagDataProcessor_MZ")) throw new Error("[SoR_EffectEnhancedItems_MZ] This plugin REQUIRES SoR_TagDataProcessor_MZ.");


const pluginName = "SoR_EffectEnhancedItems_MZ";
const Param = PluginManager.parameters(pluginName);

/////////////////////////////////////////////////////////

const SoR_EEI_DM_initializeSoRTags = DataManager.initializeSoRTags;
DataManager.initializeSoRTags = function() {
    SoR_EEI_DM_initializeSoRTags.call(this);
    this.SoR_ItemEnhanceEffs = [];
}

const SoR_EEI_DM_initializeSoRTagProcessor = DataManager.initializeSoRTagProcessor;
DataManager.initializeSoRTagProcessor = function() {
    SoR_EEI_DM_initializeSoRTagProcessor.call(this);
    const q = {name: "SoR_EEI", target: ["common"]};
    this._SoRTagProcessFuncs.push(q);
}

DataManager.SoR_EEI_init = function(obj) {
	obj.EEI_tmpdata = {
		id: 0,
		item: [],
		weapon: [],
		armor: [],
		special: [],
		newname: "%1",
		newhelp: null
	}	
}

const beginTag = /<(?:SoR_ItemEnhanceEffect):[\s]*(\d+)?>/i;
const endTag = /<(?:\/SoR_ItemEnhanceEffect):?[ ]*>/i;
const tagp_a1 = /(?:addItems):[ ]*(.*)/i;
const tagp_a2 = /(?:addWeapons):[ ]*(.*)/i;
const tagp_a3 = /(?:addArmors):[ ]*(.*)/i;
const tagp_a4 = /(?:addSpecials):[ ]*(.*)/i;
const tagp_a5 = /(?:newName):[ ]*(.*)/i;
const tagp_a6 = /(?:newHelp):[ ]*(.*)/i;
 

DataManager.SoR_EEI = function(obj, line, intensive) {
    let MatchFlag = false;

    if(!intensive){
        if(line.match(beginTag)){
			obj.EEI_tmpdata.id = Number(RegExp.$1);
            return null;
        }
        else return false;
    }

    if(intensive === true){		
		if(line.match(tagp_a1)) obj.EEI_tmpdata.item = convParamComma(RegExp.$1.trim());
		else if(line.match(tagp_a2)) obj.EEI_tmpdata.weapon = convParamComma(RegExp.$1.trim());
		else if(line.match(tagp_a3)) obj.EEI_tmpdata.armor = convParamComma(RegExp.$1.trim());
		else if(line.match(tagp_a4)) obj.EEI_tmpdata.special = convParamComma(RegExp.$1.trim());
		else if(line.match(tagp_a5)) obj.EEI_tmpdata.newname = RegExp.$1.trim();
		else if(line.match(tagp_a6)) obj.EEI_tmpdata.newhelp = RegExp.$1.trim();
        else if (line.match(endTag)){//finish tags
			this.SoR_ItemEnhanceEffs[obj.EEI_tmpdata.id-1] = JSON.parse(JSON.stringify(obj.EEI_tmpdata));
            return true;
        }
    }

    return MatchFlag;
}

function convParamComma(str){
	let id_array = [];
	const spl_str = str.split(',');

	if (!str) return id_array; //empty
	
	const nspl = spl_str.length;
	for (let i = 0; i < nspl; i++){
	   id_array.push(Number(spl_str[i])); //one ID
	}
	return id_array;
}

/////////////////////////////////////////////////////////

function convertJsonArrayI(param) {
	if (param == undefined) return [];
	let arr = [];
		JSON.parse(param).map(function(param) {
			arr.push(Number(param));
		});
	return arr;
}


function convertJsonParams(param) {
    if (param == undefined) return [];
    let arr = [];
        JSON.parse(param).map(function(param) {
        const obj = JSON.parse(param);
            obj.origin_type = Number(obj.origin_type);
            obj.item_i = Number(obj.item_i);
            obj.item_w = Number(obj.item_w);
            obj.item_a = Number(obj.item_a);
            obj.addId = Number(obj.addId);
            obj.origin_type = Number(obj.origin_type);
            obj.price = Number(obj.price);
            delete obj.Note;
            arr.push(obj);
        });
    return arr;
}


PluginManager.registerCommand(pluginName, "createEnhancedItem", args => {
	if(!Number.isFinite(Number(args.arg0))) return;
    const basetype = Number(args.arg0);
	let basetarget = 0;
	switch(basetype){
		case 1:
		basetarget = Number(args.arg1);
		break;
		case 2:
		basetarget = Number(args.arg2);
		break;
		case 3:
		basetarget = Number(args.arg3);
		break;
		default:
		return;
	}

	const effarr = [];
	for(const x of convertJsonArrayI(args.arg4)) effarr.push({type: "item", id: x});
	for(const x of convertJsonArrayI(args.arg5)) effarr.push({type: "weapon", id: x});
	for(const x of convertJsonArrayI(args.arg6)) effarr.push({type: "armor", id: x});
	const newname = args.arg7.trim();	
	
	const data = {
		basetype, basetarget, newname
	};
	
	DataManager.createNewExItem(data, effarr);
});




PluginManager.registerCommand(pluginName, "callEnhancedItemShop", args => {
	const itemlist = convertJsonParams(args.inventory);	
	const flag = args.buyOnly==="true" ? true : false;
	const shoplist = [];
	
	for(const x of itemlist){
		let idx = 0;
		if(x.origin_type==1) idx = x.item_i;
		else if(x.origin_type==2) idx = x.item_w;
		else if(x.origin_type==3) idx = x.item_a;
		else continue;
		
		const pf = x.price!=-1? 1 : 0;
		const p = x.price!=-1? x.price : 0;
		
		const dat = [x.origin_type-1,idx,pf,p,flag,x.addId];
		shoplist.push(dat);
	}
	
    SceneManager.push(Scene_ShopSoREEI);
    SceneManager.prepareNextScene(shoplist, flag);
});



PluginManager.registerCommand(pluginName, "createEnhancedItem2", args => {
	if(!Number.isFinite(Number(args.arg0))) return;
    const basetype = Number(args.arg0);
	let basetarget = 0;
	switch(basetype){
		case 1:
		basetarget = Number(args.arg1);
		break;
		case 2:
		basetarget = Number(args.arg2);
		break;
		case 3:
		basetarget = Number(args.arg3);
		break;
		default:
		return;
	}

	const dbid = Number(args.arg4);
	const db = DataManager.SoR_ItemEnhanceEffs[dbid-1];

	const effarr = [];
	for(const x of db.item) effarr.push({type: "item", id: x});
	for(const x of db.weapon) effarr.push({type: "weapon", id: x});
	for(const x of db.armor) effarr.push({type: "armor", id: x});
	const newname = db.newname;
	
	const data = {
		basetype, basetarget,
		effarr, newname
	};
	DataManager.createNewExItem(data, effarr);

});

/////////////////////////////////////////////////////////

DataManager.createNewExItem = function(data, effarr){
	const item = this.prepareNewExItem(data);
	if(item==null) return;
	
    const newdata = { id: data.basetarget,
       addData: effarr,
       addEffects: [],
       newname: data.newname
    }
	
    this.registerNewExItem(item, newdata);
}


DataManager.prepareNewExItem = function(data){
	let item = null;
	switch(data.basetype){
		case 1:
		item = $dataItems[data.basetarget];
		break;
		case 2:
		item = $dataWeapons[data.basetarget];
		break;
		case 3:
		item = $dataArmors[data.basetarget];
		break;
	}
	if(!item) return null;
	return item;
}




/////////////////////////////////////////////////////////

const SoR_EEI_GE_processDropEX = Game_Enemy.prototype.processDropEX;
Game_Enemy.prototype.processDropEX = function(itemobj, di) {
	const base = SoR_EEI_GE_processDropEX.call(this, ...arguments);
	
	if(typeof di.exdataSourceId === "undefined") return base;
	
	const dbid = di.exdataSourceId;
	const db = DataManager.SoR_ItemEnhanceEffs[dbid-1];
		
	const effarr = [];
	for(const x of db.item) effarr.push({type: "item", id: x});
	for(const x of db.weapon) effarr.push({type: "weapon", id: x});
	for(const x of db.armor) effarr.push({type: "armor", id: x});	
	const newname = db.newname;

	const data = {
		basetype: di.exkind, 
		basetarget: di.dataId,
		effarr, newname
	};
	
	const item = DataManager.prepareNewExItem(data);
	if(item==null) return null;
	
	const newdata = {
		id: di.dataId,
		addData: effarr,
		addEffects: [],
		newname
	};
	return DataManager.createNewExItemEntry(item, newdata);	
}



/////////////////////////////////////////////////////////

function Scene_ShopSoREEI() {
    this.initialize(...arguments);
}

Scene_ShopSoREEI.prototype = Object.create(Scene_Shop.prototype);
Scene_ShopSoREEI.prototype.constructor = Scene_ShopSoREEI;

Scene_ShopSoREEI.prototype.initialize = function() {
	Scene_Shop.prototype.initialize.call(this,...arguments);
}

Scene_ShopSoREEI.prototype.prepare = function(goods, purchaseOnly) {
	Scene_Shop.prototype.prepare.call(this,...arguments);
}

Scene_ShopSoREEI.prototype.createBuyWindow = function() {
    const rect = this.buyWindowRect();
    this._buyWindow = new Window_ShopBuySoREEI(rect);
    this._buyWindow.setupGoods(this._goods);
    this._buyWindow.setHelpWindow(this._helpWindow);
    this._buyWindow.setStatusWindow(this._statusWindow);
    this._buyWindow.hide();
    this._buyWindow.setHandler("ok", this.onBuyOk.bind(this));
    this._buyWindow.setHandler("cancel", this.onBuyCancel.bind(this));
    this.addWindow(this._buyWindow);
}

Scene_ShopSoREEI.prototype.doBuy = function(number) {
	if(typeof this._item.exdataId == "undefined"){
		Scene_Shop.prototype.doBuy.call(this, number);
		return;
	}

	//purchase exItem 
    $gameParty.loseGold(number * this.buyingPrice());
	for(let i=0; i<number; i++){		
		const orig = this._buyWindow.getExData_original();
		const ex = this._buyWindow.getExData();
		DataManager.registerNewExItem(orig, ex);
	}

}



function Window_ShopBuySoREEI() {
    this.initialize.apply(this, arguments);
}

Window_ShopBuySoREEI.prototype = Object.create(Window_ShopBuy.prototype);
Window_ShopBuySoREEI.prototype.constructor = Window_ShopBuySoREEI;

Window_ShopBuySoREEI.prototype.initialize = function(rect) {
    Window_ShopBuy.prototype.initialize.call(this, rect);
	this.exContainer_local = [];
	this._tmpExItemData = {};
	this._shopGoods = [];
}


Window_ShopBuySoREEI.prototype.setupGoods = function(shopGoods) {
    //Window_ShopBuy.prototype.setupGoods.call(this, shopGoods);
	this.setupGoods_Ex(shopGoods);
    this.refresh();
    this.select(0);
}

Window_ShopBuySoREEI.prototype.getExOriginalItemContainerID = function(item) {
    if(item.itypeId) return 0;
    if(item.wtypeId) return 1;
    if(item.atypeId) return 2;
    return null;
}


Window_ShopBuySoREEI.prototype.setupGoods_Ex = function(shopGoods) {
	for(const x of shopGoods){
		if(x[5]==0) this._shopGoods.push(x);
		else{
			const db = DataManager.SoR_ItemEnhanceEffs[x[5]-1];
			const effarr = [];
			for(const y of db.item) effarr.push({type: "item", id: y});
			for(const y of db.weapon) effarr.push({type: "weapon", id: y});
			for(const y of db.armor) effarr.push({type: "armor", id: y});
			const newname = db.newname;
			const data = {
				basetype: x[0]+1,
				basetarget: x[1],
				effarr, newname
			};
			
			const item = DataManager.prepareNewExItem(data);
			if(item==null) return null;
			
			const newdata = {
				id: x[1], addData: effarr,
				addEffects: [], newname
			};
			
			this.exContainer_local.push(newdata);
			const idx = this.exContainer_local.length-1;
			const exdata = DataManager.generateItemWithEXproperty(item,newdata, idx);
			
			const tmpidx = 100000*(this.getExOriginalItemContainerID(exdata)+1) + exdata.exdataId;
			this._tmpExItemData[tmpidx] = exdata;
			x[4] = x[1];//tmp data
			x[1] = tmpidx;
			this._shopGoods.push(x);
		}
	}

}


Window_ShopBuySoREEI.prototype.goodsToItem = function(goods) {
	if(goods[5]!=0)	return this.goodsToExItem(goods);
	return Window_ShopBuy.prototype.goodsToItem.call(this, goods);
}


Window_ShopBuySoREEI.prototype.goodsToExItem = function(goods) {
	return this._tmpExItemData[goods[1]];
}


Window_ShopBuySoREEI.prototype.getExData = function() {
	const item = this.itemAt(this._index);
	return this.exContainer_local[item.exdataId];
}

Window_ShopBuySoREEI.prototype.getExData_original = function() {
	const d = this._shopGoods[this._index].slice();
	d[1] = d[4];
	d[5] = 0;
	return this.goodsToItem(d);
}


/////////////////////////////////////////////////////////////////
const SoR_EEI_WSS_drawPossession = Window_ShopStatus.prototype.drawPossession;
Window_ShopStatus.prototype.drawPossession = function(x, y) {
	if(typeof this._item.exdataId !== "undefined") return;	
	SoR_EEI_WSS_drawPossession.call(this, ...arguments);
}


})();